/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockEmergentTallWaterPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockFloatingWaterTFC
extends BlockPlantTFC {
    private static final AxisAlignedBB LILY_PAD_AABB = new AxisAlignedBB(0.0, -0.125, 0.0, 1.0, 0.0625, 1.0);
    private static final Map<Plant, BlockFloatingWaterTFC> MAP = new HashMap<Plant, BlockFloatingWaterTFC>();

    public static BlockFloatingWaterTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockFloatingWaterTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(this.getDayPeriod())).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())));
        this.func_176475_e(world, pos, state);
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityBoat) {
            worldIn.func_175655_b(new BlockPos((Vec3i)pos), true);
        }
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return BlocksTFC.isWater(state) || state.func_185904_a() == Material.field_151588_w && state == this.plant.getWaterType() || state.func_185904_a() == Material.field_151589_v && !(state.func_177230_c() instanceof BlockEmergentTallWaterPlantTFC);
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            Material material = stateDown.func_185904_a();
            return material == Material.field_151586_h && (Integer)stateDown.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && stateDown == this.plant.getWaterType() || material == Material.field_151588_w || material == Material.field_151589_v && !(state.func_177230_c() instanceof BlockEmergentTallWaterPlantTFC);
        }
        return false;
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return LILY_PAD_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.growthStageProperty, DAYPERIOD, AGE});
    }
}

